#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.7 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

from    py_netasq.commonlib     import asqDebug, asqLogging, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore
from    py_netasq.building      import tasks    as asqBuildTasks
from    py_netasq.building      import parsing  as asqBuildParsing


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.DEBUG
#~ DBG_LOGLVL = logging.INFO

# globally disable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aCheckerDebug = asqDebug.objectDebug(asqBuildParsing.fileChecker, 'aCheckerDebug')
aCheckerDebug.logger    = DBG_LOGGER
aCheckerDebug.logLevel  = DBG_LOGLVL

asqRepr.aRepr.logger    = DBG_LOGGER
asqRepr.aRepr.logLevel  = logging.DEBUG
asqRepr.aRepr.maxstring = 40
asqRepr.aRepr.maxlist   = 15
asqRepr.aRepr.maxdict   = 15


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


print ''

aCheckerDebug.objectInit()
aCheckerDebug.objectCallFunc('readFile', filename='AdminSuite.ini')

print ''

buffer = aCheckerDebug.objectGetAttr('status.totalInfosCount')
DBG_LOGGER.log(logging.DEBUG, '> status.totalInfosCount')
asqRepr.representation(buffer)

buffer = aCheckerDebug.objectGetAttr('status.totalCriticalsCount')
DBG_LOGGER.log(logging.DEBUG, '> aCheckerDebug.status.totalCriticalsCount')
asqRepr.representation(buffer)

buffer = aCheckerDebug.objectGetAttr('status.totalErrorsCount')
DBG_LOGGER.log(logging.DEBUG, '> aCheckerDebug.status.totalErrorsCount')
asqRepr.representation(buffer)

buffer = aCheckerDebug.objectGetAttr('status.totalWarningsCount')
DBG_LOGGER.log(logging.DEBUG, '> aCheckerDebug.status.totalWarningsCount')
asqRepr.representation(buffer)


aCheckerDebug.objectCallFunc('status.report', DBG_LOGGER)

#~ asqBuildParsing.fileChecker.checkFile('AdminSuite.ini', DBG_LOGGER)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -