#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Defines 'core' exceptions classes for the py_netasq.building module.

Require
  Python        2.2

Classes
  class         Error                   extends Exception
  class         taskError               extends Error
  class         taskHandlerError        extends Error
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#~ import  nothing

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class Error(Exception) :
    """\
      Base class for module exceptions.
    """
    pass


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class Error  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class taskError(Error) :
    """\
      Exception raised if the task cannot be ran, typically, if it is
      found invalid.
    """

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self, message, aTask):
        """\
          constructor taskError(string message, object aTask)
          
          Exception constructor, 'nuff said.
          
          param message               exception message
          param aTask                 faulty task item
        """
        self.message = message
        self.task    = aTask


  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class taskError  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

class taskHandlerError(Error) :
    """\
      Exception raised as a task item is being processed, i.e. the command
       is being executed.
    """

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    def __init__(self, status, output, aTask):
        """\
          constructor taskHandlerError(int status, list output, object aTask)
          
          Exception constructor, 'nuff said.
          
          param status                shell status, error code
          param output                last command output
          param aTask                 faulty task item
        """
        self.status = status
        self.output = output
        self.task   = aTask


  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Getters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Setters - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # Properties  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

  # /class taskHandlerError - - - - - - - - - - - - - - - - - - - - - - - - - -



# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -