#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Imports all needed stuff from "core" package units into package's
namespace.

Require
  Python        2.2

Classes
  class         Error                   extends Exception
  class         taskError               extends Error
  class         taskHandlerError        extends Error
  
  class         task(bool enabled)
  class         taskItem(bool enabled)  extends task
  class         taskList(bool enabled)  extends task
  class         taskHandler(object aTask)
                  extends py_netasq.commonlib.asqWin::winCmdHandler

  class         checkResult(list aList)
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.6 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# __all__ should contain the entire public API. It is intended to avoid
# accidentally exporting items that are not part of the API (such as
# library modules which were imported and used within the module).

__all__ = [
    'checkResult',
    'errors',
    'task',
    'taskItem',
    'taskList',
    'taskHandler',
  ]

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

from    errors                  import  Error, taskError, taskHandlerError

from    task                    import  task
from    taskItem                import  taskItem
from    taskList                import  taskList
from    taskHandler             import  taskHandler

from    checkResult             import  checkResult

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -