#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

from    py_netasq.commonlib     import asqDebug, asqLogging, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally enable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskListDebug = asqDebug.objectDebug(asqBuildCore.taskList, 'aTaskListDebug')
aTaskListDebug.logger   = DBG_LOGGER
aTaskListDebug.logLevel = DBG_LOGLVL

aTaskItemDebug = asqDebug.objectDebug(asqBuildCore.taskItem, 'aTaskItemDebug')
aTaskItemDebug.logger   = DBG_LOGGER
aTaskItemDebug.logLevel = DBG_LOGLVL

asqRepr.aRepr.logger    = DBG_LOGGER
asqRepr.aRepr.logLevel  = logging.DEBUG


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''

aTaskListDebug.classAttributes()

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ aTaskListDebug.objectInit(enabled=False)
#~ aTaskListDebug.objectDel()


aTaskListDebug.objectInit(enabled=False)
#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')
aTaskItemDebug.objectInit(enabled=False)
#~ print ''
#~ aTaskItemDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskListDebug.objectSetAttr('enabled'      , True)
aTaskListDebug.objectSetAttr('workdir'      , '.')
aTaskListDebug.objectSetAttr('logFile'      , r'..\logfile.log')
aTaskListDebug.objectSetAttr('zobi'         , 'biroutte')
#~ aTaskListDebug.objectCallFunc('debug')

print ''
aTaskListDebug.objectCallFunc('completePaths', None)
#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

#~ print ''
#~ buffer = aTaskListDebug.objectCallFunc('toList', filtered=False)
#~ asqRepr.representation(buffer)
#~ print ''
#~ buffer = aTaskListDebug.objectCallFunc('toList', filtered=True)
#~ asqRepr.representation(buffer)

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskListDebug.objectCallFunc('append', aTaskItemDebug.object)
aTaskItemDebug.objectCallFunc('mergeWithTask', aTaskListDebug.object)
#~ print ''
#~ aTaskListDebug.objectCallFunc('debug')

print ''

aTaskListDebug.objectCallFunc('appendNewTask')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''

buffer = aTaskListDebug.objectCallFunc('check')
asqRepr.representation(buffer)
buffer.debug()
print ''
aTaskListDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskListDebug.objectCallFunc('reset')
print ''
aTaskListDebug.objectCallFunc('debug')

print ''
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -