#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.2 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

from    py_netasq.commonlib     import asqDebug, asqLogging, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally enable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aHandlerDebug = asqDebug.objectDebug(asqBuildCore.taskHandler, 'aHandlerDebug')
aHandlerDebug.logger    = DBG_LOGGER
aHandlerDebug.logLevel  = DBG_LOGLVL

aTaskItemDebug = asqDebug.objectDebug(asqBuildCore.taskItem, 'aTaskItemDebug')
aTaskItemDebug.logger   = DBG_LOGGER
aTaskItemDebug.logLevel = DBG_LOGLVL


asqRepr.aRepr.logger    = DBG_LOGGER
asqRepr.aRepr.logLevel  = logging.DEBUG


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''


aHandlerDebug.classAttributes()
print '# - - - - - - - - - - - - - - - - - - -'
print ''

aTaskItemDebug.classAttributes()
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskItemDebug.objectInit(enabled=False)
#~ aTaskItemDebug.objectCallFunc('debug')
print ''
aTaskItemDebug.objectSetAttr('workdir'      , '.')
aTaskItemDebug.objectSetAttr('logFile'      , r'..\logfile.log')
aTaskItemDebug.objectSetAttr('zobi'         , 'biroutte')
print ''
#~ aTaskItemDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aHandlerDebug.objectInit()
#~ aHandlerDebug.objectCallFunc('debug')
print ''
aHandlerDebug.objectSetAttr('task', aTaskItemDebug.object)
#~ aHandlerDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


buffer = aHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aHandlerDebug.objectSetAttr('task.enabled', True)
aHandlerDebug.objectCallFunc('debug')
print ''
buffer = aHandlerDebug.objectCallFunc('run')
asqRepr.representation(buffer)
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -