#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.4 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging

from    py_netasq.commonlib     import asqDebug, asqLogging, asqRepr

from    py_netasq               import building as asqBuild
from    py_netasq.building      import core     as asqBuildCore


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DBG_LOGGER = asqBuild.logger
DBG_LOGLVL = logging.INFO

# globally enable TRACE logging message
asqBuild.logger.excludeLvl.append(asqLogging.TRACE)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

aTaskDebug = asqDebug.objectDebug(asqBuildCore.task, 'aTaskDebug')
aTaskDebug.logger       = DBG_LOGGER
aTaskDebug.logLevel     = DBG_LOGLVL

aTaskItemDebug = asqDebug.objectDebug(asqBuildCore.taskItem, 'aTaskItemDebug')
aTaskItemDebug.logger   = DBG_LOGGER
aTaskItemDebug.logLevel = DBG_LOGLVL

asqRepr.aRepr.logger    = DBG_LOGGER
asqRepr.aRepr.logLevel  = logging.DEBUG


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

print ''

aTaskDebug.classAttributes()
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskDebug.objectInit(enabled=False)
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskDebug.objectDel()
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskDebug.objectInit(enabled=False)
print ''
#~ aTaskDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskDebug.objectSetAttr('taskname'     , 'RawTask_X')
aTaskDebug.objectSetAttr('enabled'      , True)
aTaskDebug.objectSetAttr('workdir'      , '.')
aTaskDebug.objectSetAttr('logFile'      , r'..\logfile.log')
aTaskDebug.objectSetAttr('zobi'         , 'biroutte')
print ''
aTaskDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


aTaskDebug.objectCallFunc('completePaths', baseDir=r'C:\.')
print ''
#~ aTaskDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


buffer = aTaskDebug.objectCallFunc('check')
#~ asqRepr.representation(buffer)
buffer.debug()
print '# - - - - - - - - - - - - - - - - - - -'
print ''


#~ buffer = aTaskDebug.objectCallFunc('toList', filtered=False)
#~ asqRepr.representation(buffer)
#~ print ''
#~ buffer = aTaskDebug.objectCallFunc('toList', filtered=True)
#~ asqRepr.representation(buffer)
#~ print '# - - - - - - - - - - - - - - - - - - -'
#~ print ''


aTaskDebug.objectCallFunc('reset')
print ''
#~ aTaskDebug.objectCallFunc('debug')
print '# - - - - - - - - - - - - - - - - - - -'
print ''


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -