#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

"""\
Performs version check + sets up a message logger.

Require
  Python   2.3.4

Constants
  tuple         VERSION
  tuple         REQUIRED_PY
  
  bool          LOGGER_DISABLED
  string        LOGGER_CONFIG
  string        LOGGER_NAME

Properties
  object        logger
"""

__author__  = "Benoit Kogut-Kubiak"
__email__   = "benoit.kogutkubiak@netasq.com"
__version__ = "$Revision: 1.3 $"[11:-2]


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  os
import  sys

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# asqBuild module version
VERSION = (2, 0, 0)
# required interpreter
REQUIRED_PY = ('2', '3', '4')

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# logging module is only available since python 2.3
if REQUIRED_PY > tuple(sys.version.split()[0].split('.')) :
  buffer = '.'.join(REQUIRED_PY)
  sys.exit(
      '%s: error: version check failed, please update to '
      'Python %s' % (__file__, buffer)
    )
  del buffer

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

import  logging
import  logging.config

from    py_netasq.commonlib     import asqLogging, asqPath

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

LOGGER_DISABLED = not __debug__
# path to logger config file path *must* be absolute
LOGGER_CONFIG   = os.path.join(asqPath.directory(__file__), r'..\logConfig.ini')
LOGGER_NAME     = 'asqBuild'

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

logging.setLoggerClass(asqLogging.customLogger)
logging.config.fileConfig(LOGGER_CONFIG)

logger = logging.getLogger(LOGGER_NAME)
logger.disabled = LOGGER_DISABLED

# globally disable TRACE logging message
logger.excludeLvl.append(asqLogging.TRACE)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

if '__main__' == __name__ :
  print __file__
  print __doc__
#~ else :
  #~ # check out customLogger logger
  #~ logger.info('%s logger enabled', logger.name)


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

del logging.config
del logging
del sys
del os

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -